/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8245;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8245.BoxInfo;
import ibm.nways.jdm8245.eui.AltConfigurationGroup;
import ibm.nways.jdm8245.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8245.eui.FaultFolderGroup;
import ibm.nways.jdm8245.eui.SecurityFolderGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rmon.RmonContext;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebBrowserGroup;
import ibm.nways.web.WebContext;
import java.util.ResourceBundle;

public class Jdm8245
extends JdmBrowser {
    private static String bundleName = "ibm.nways.jdm8245.Resources";
    private static String RootFolderTitle = "RootFolderTitle";
    private static String FaultGroupTitle = "FaultGroupTitle";
    private static String OtherAppsGroupTitle = "OtherAppsGroupTitle";
    private static String MibBrowserTitle = "MibBrowserTitle";
    private static String StartGraphic = "StartGraphic";
    private static String EndGraphic = "EndGraphic";
    private static String StartNavTree = "StartNavTree";
    private static String EndNavTree = "EndNavTree";
    private ResourceBundle myResources;
    private static final int RASID = 19;
    private static final int RASSUB = 20;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private NavFieldOverride jdm8245Overrides;
    private GenModel deviceModel;
    BoxInfo boxInfo;
    public IPAddress[] backupAddresses = new IPAddress[]{null, null, null};
    static final Object[][] jdm8245FieldOverrides = new Object[][]{{"ibm.nways.mib2.model.System.Panel.SysDescr.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysContact.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysName.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysLocation.length", "48"}, {"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IfDescr.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteProto.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteInfo.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfAdminStatus.access", "read-only"}, {"ibm.nways.mib2.eui.Mib2InterfacesPanel.rfc1573.visible", "false"}, {"ibm.nways.mib2.model.Interface.Panel.IfName.access", "not-supported"}, {"ibm.nways.mib2.model.Interface.Panel.IfPromiscuousMode.access", "not-supported"}, {"ibm.nways.mib2.model.Interface.Panel.IfConnectorPresent.access", "not-supported"}, {"ibm.nways.mib2.model.Interface.Panel.IfLinkUpDownTrapEnable.access", "not-supported"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.jdm8245.model.AgentIp.Panel.AgentIpIfType.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}};

    public String getModelTypeName() {
        return "ibm.nways.jdm8245.model.Jdm8245Folder";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        this.displayMsg(this.myResources.getString(StartGraphic));
        GraphicPanel graphicPanel = this.boxInfo.getDeviceGraphic();
        this.displayMsg(this.myResources.getString(EndGraphic));
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        if (this.myResources == null) {
            this.myResources = ResourceBundle.getBundle(bundleName);
        }
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            this.boxInfo = new BoxInfo(this.deviceModel, this);
        } else {
            if (this.boxInfo != null) {
                this.boxInfo.dispose();
                this.boxInfo = null;
            }
            this.boxInfo = new BoxInfo(this.deviceModel, this);
            this.rootFolder = this.boxInfo.getDeviceStatus() == 1 ? new NavigationFolder(this.myResources.getString(RootFolderTitle)) : new NavigationFolder(this.myResources.getString("UNKNOWN"));
            this.navContext = this.rootFolder.getNavContext();
            this.jdm8245Overrides = new NavFieldOverride(this.navContext, jdm8245FieldOverrides);
            BoxInfo.setInNavContext(this.navContext, this.boxInfo);
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        String string = "getRestOfNavTree";
        this.displayMsg(this.myResources.getString(StartNavTree));
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[]{1};
        RmonContext rmonContext = new RmonContext(nArray2, nArray3, nArray4);
        this.navContext.put((Object)"rmonContext", (Object)rmonContext);
        if (this.deviceModel != null && (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 3)) {
            if (RAS.isEnabled(19, 20)) {
                RAS.trace(19, 20, (Object)this, string, "Build full Tree -- Box Status" + this.boxInfo.getDeviceStatus());
            }
            this.buildConfigurationFolder(this.rootFolder);
            this.buildFaultFolder(this.rootFolder);
            this.buildSecurityFolder(this.rootFolder);
            this.buildOtherAppsFolder(this.rootFolder);
        } else {
            if (RAS.isEnabled(19, 20)) {
                RAS.trace(19, 20, (Object)this, string, "Build Alt folder -- Box Status" + this.boxInfo.getDeviceStatus());
            }
            this.buildAltConfigurationFolder(this.rootFolder);
            this.buildOtherAppsFolder(this.rootFolder);
        }
        this.displayMsg(this.myResources.getString(EndNavTree));
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        GenModel genModel;
        String string = "buildConfigurationFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 20)) {
                RAS.trace(19, 20, (Object)this, string, "Not able to get config model");
            }
            genModel = this.deviceModel;
        }
        ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
        configurationFolderGroup.setIsInitiallyExpanded(false);
        this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
        navigationFolder.add((NavigationPoint)configurationFolderGroup);
    }

    private void buildAltConfigurationFolder(NavigationFolder navigationFolder) {
        GenModel genModel;
        String string = "buildAltConfigurationFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 20)) {
                RAS.trace(19, 20, (Object)this, string, "Not Able to get Config model");
            }
            genModel = this.deviceModel;
        }
        AltConfigurationGroup altConfigurationGroup = new AltConfigurationGroup((JdmBrowser)this, genModel);
        altConfigurationGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        altConfigurationGroup.setIsInitiallyExpanded(true);
        this.tree.addEventListener((NavigationBrowserEventListener)altConfigurationGroup);
        navigationFolder.add((NavigationPoint)altConfigurationGroup);
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel;
        String string = "buildSecurityFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("SecurityFolder");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 20)) {
                RAS.trace(19, 20, (Object)this, string, "Not Able to get SecurityFolder model");
            }
            genModel = this.deviceModel;
        }
        SecurityFolderGroup securityFolderGroup = new SecurityFolderGroup((JdmBrowser)this, genModel);
        securityFolderGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        securityFolderGroup.setIsInitiallyExpanded(false);
        this.tree.addEventListener((NavigationBrowserEventListener)securityFolderGroup);
        navigationFolder.add((NavigationPoint)securityFolderGroup);
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel;
        String string = "buildFaultFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("FaultFolder");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 20)) {
                RAS.trace(19, 20, (Object)this, string, "Not Able to get FaultFolder model");
            }
            genModel = this.deviceModel;
        }
        FaultFolderGroup faultFolderGroup = new FaultFolderGroup((JdmBrowser)this, genModel);
        faultFolderGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        faultFolderGroup.setIsInitiallyExpanded(false);
        this.tree.addEventListener((NavigationBrowserEventListener)faultFolderGroup);
        navigationFolder.add((NavigationPoint)faultFolderGroup);
    }

    private void buildOtherAppsFolder(NavigationFolder navigationFolder) {
        block3: {
            String string = "buildOtherAppsFolder";
            NavigationFolder navigationFolder2 = null;
            navigationFolder2 = new NavigationFolder(this.myResources.getString(OtherAppsGroupTitle));
            navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.setIsInitiallyExpanded(true);
            navigationFolder.add((NavigationPoint)navigationFolder2);
            try {
                SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
                ModelInfo modelInfo = snmpContextModel.getConfig();
                String string2 = modelInfo.get("Config.Address").toString();
                ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
                TelnetContext telnetContext = new TelnetContext(string2);
                NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
                NavigationContext navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"telnetContext", (Object)telnetContext);
                navigationFolder2.add((NavigationPoint)navigationItem);
                NavigationBrowser navigationBrowser = this.getNavigationBrowser();
                Browser browser = new Browser(this.myResources.getString(MibBrowserTitle), (JdmBrowser)this, snmpContextModel);
                navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
                navigationFolder2.add((NavigationPoint)browser.getRootFolder());
                WebContext webContext = new WebContext(string2);
                webContext.support_and_device();
                WebBrowserGroup webBrowserGroup = new WebBrowserGroup(webContext);
                webBrowserGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
                webBrowserGroup.setIsInitiallyExpanded(false);
                navigationBrowser.addEventListener((NavigationBrowserEventListener)webBrowserGroup);
                navigationFolder2.add((NavigationPoint)webBrowserGroup);
                if (this.getIsApplication()) {
                    AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string2, this.getServerPortNumber());
                    NavigationItem navigationItem2 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                    navigationContext = navigationItem2.getNavContext();
                    navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                    navigationFolder2.add((NavigationPoint)navigationItem2);
                    return;
                }
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(19, 20)) break block3;
                RAS.trace(19, 20, (Object)this, string, "Problem addding the Tools folder");
            }
        }
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 20)) {
            RAS.trace(19, 20, (Object)this, string, "Shutting down");
        }
        this.myResources = null;
        this.rootFolder = null;
        this.tree = null;
        this.navContext = null;
        this.jdm8245Overrides = null;
        this.boxInfo.dispose();
        this.boxInfo = null;
        this.deviceModel = null;
        super.dispose();
    }
}

